#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# saprfc.py  -  datasource using pyrfc
#
# Copyright (C) 2018 PerFact Innovation GmbH & Co. KG <info@perfact.de>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

import subprocess

needed_args = ['ashost', 'sysnr', 'client', 'user', 'passfile']


def connector2args(connector):
    args_list = connector.split(';')
    args_dict = {
        item.split('=')[0].strip().lower(): item.split('=')[1].strip()
        for (item) in args_list
    }
    return args_dict


def createParams(rfc_name, query):
    params = '''{"name": "%s",
"params": %s
}''' % (rfc_name, query)
    return params


class SAPConnection(object):
    ''' For SAP-RFCs using pyrfc '''

    def __init__(self, connector, dbtype=''):
        self.args_dict = connector2args(connector)
        self._connected = False
        self.error = None
        self.sap_response = ''
        self.dbtype = dbtype

    def connect(self):
        for arg in needed_args:
            if arg not in self.args_dict:
                self.error = 'Arg %s missing' % arg
                return False
        self._connected = self.testConnection()
        if not self._connected:
            self.error = self.sap_response
        return self._connected

    def disconnect(self):
        return

    def close(self):
        return

    @property
    def connected(self):
        if self._connected:
            return True
        else:
            return False

    def prepareArgs(self):
        # XXX TODO: This path is not part of this package!
        args = ['/opt/perfact/rfc/bin/rrfcwrapper', ]
        for arg in needed_args:
            args.append('--%s' % arg)
            args.append(self.args_dict[arg])
        return ' '.join(args)

    def execute(self, query, rfc_name=None):
        ''' query can be a json block of rfc_names and params '''
        args = self.prepareArgs()
        proc = subprocess.Popen(
            args, stdin=subprocess.PIPE, stdout=subprocess.PIPE, shell=True)
        if rfc_name:
            params = createParams(rfc_name, query)
        else:
            params = query
        output, error = proc.communicate(input=params)
        # detect errors
        if error > 0:
            raise Exception('RFC call failed')
        return output

    def testConnection(self):
        args = self.prepareArgs()
        args.append('--test')
        proc = subprocess.Popen(args, stdout=subprocess.PIPE, shell=True)
        output = proc.communicate()[0]
        if 'Test passed' in output:
            return True
        self.sap_response = output
        return False
